%Note that the scripts in the Dependencies folder are required to run the
%script
clear
close all
fig_dir=pwd;
file_dir=pwd;

%Loads processed data of the duty cycle scan
load([file_dir,'\metadata_duty_800M.mat']);
%Loads processed data of the reference trace
ref=load([file_dir,'\ref_data_800M.mat']);
fig_no=10;
%Sets the beginning and end of the plot
x_min=0;
x_max=max(cellfun(@(x) max(x),x_mean));
x_vec=linspace(x_min,x_max,1e4);

fig=figure(fig_no)
%Colors data that is in the strobe and above a threshold differently
new_ind=comb_ind{1} | y_mean{1}>0.08;
plot(x_mean{1}(new_ind),y_mean{1}(new_ind),'Color','r','Marker','.',...
    'LineStyle','none','MarkerSize',4);
hold on
plot(x_mean{1}(~new_ind),y_mean{1}(~new_ind),'Color',rgb('light gray'),'Marker','.',...
    'LineStyle','none','MarkerSize',4);
hold on

ref_line=plot(ref.x_mean,ref.y_mean,'Color',[rgb('red'),0.3]);

xlabel('Time (s)')
ylabel('Amplitude (normalized)')
set(gca,'YScale','Log');
axis([0,420,1e-2,1.3]);

box on
plot(x_vec,ref.fitdata(x_vec),'Color','k','LineStyle',':')

set(fig,'Color','w')
makePDF_klab(fig_no,sprintf('MainPlot'),18,6,fig_dir)